set sql_safe_updates=0;

SET @rejectApplicationDL=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_DL');

UPDATE `sql_dtprovider` SET `sqlQuery`="SELECT T1.id AS USER_ID
FROM `application_program` T1
INNER JOIN application T2 ON T1.applicationId = T2.id
WHERE T1.id IN (namedParams)" WHERE `dataProviderId`=@rejectApplicationDL;  

SET @rejectApplication=(SELECT id FROM dtprovider WHERE `dataProviderName`='REJECT_APPLICATION_RECIPIENTS');

UPDATE `sql_dtprovider` SET `sqlQuery`="select T4.id AS ID,
	T3.`salutationName` AS SALUTATION_NAME,
	T2.`firstName` AS FIRST_NAME,
	T2.`middleName` AS MIDDLE_NAME,
	T2.`lastName` AS LAST_NAME,
	T2.`emailId` AS EMAIL_ID,
	T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` as APPLICATION_CODE,
    T5.displayName AS ACADEMY_NAME_LOCATION,
    CONCAT(T7.addressText,' ',T8.cityName,', ',T9.countryName,', ',T10.countryRegionName) AS ACADEMY_LOCATION_ADDRESS,
    CONCAT(T7.phoneCountryCode,'-',T7.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
    T7.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
    T11.programName AS PROGRAM_NAME,
    T13.batchName AS BATCH_NAME,
    T14.printName AS APPLICATION_OWNER_NAME,
    T16.emailId AS OWNER_EMAIL_ID,
	ml.`code` AS LANGUAGE_KEY,
    CONCAT(T16.mobileCountryCode,
            ' ',
            T16.mobileNumber) AS OWNER_MOBILE_NO,
    (CASE
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NOT NULL
        THEN
            CONCAT(org.orgUrl,
                    '/',
                    'emailer/images/logo_default_image.png')
        WHEN
            T5.logoUrl IS NULL
                AND org.orgUrl IS NULL
        THEN
            'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', T5.logoUrl)
    END) AS LOGO_URL,
T3.`salutationNameInOtherLanguage` AS TITLE_IN_OTHER_LANGUAGE,T11.`programNameToBePrintLanguageOne` AS PROGRAM_PRINT_NAME_LANGUAGE
    from application T1 
		left outer join
    applicant_person T2 on T1.applicantPersonId=T2.id
		inner join
	salutations T3 on T3.id = T2.salutationId
		LEFT JOIN
    application_program T4 ON T4.applicationId = T1.id
		LEFT OUTER JOIN
    academy_location T5 ON T5.id = T4.academyLocationId
		LEFT OUTER JOIN
    academy_location_addresses T6 ON T6.academyLocationId = T5.id
		LEFT OUTER JOIN
    address T7 ON T7.id = T6.addressId && T7.addressTypeId=10
		LEFT OUTER JOIN
	city T8 ON T8.id = T7.cityId
		LEFT OUTER JOIN
	country T9 ON T9.id = T8.countryId
		LEFT OUTER JOIN
	country_region T10 ON T10.id = T8.countryRegionId
		LEFT OUTER JOIN
	programs T11 ON T11.id = T4.programId
		LEFT JOIN
	batches T13 ON T13.programId=T11.id
		LEFT JOIN
	users T14 ON T14.id=T1.applicationOwner
		LEFT JOIN
    staffs T15 ON T15.userId = T14.id
        LEFT JOIN
    persons T16 ON T16.id = T15.personId
		LEFT JOIN
    multi_language ml ON ml.id = T2.correspondence_language
		LEFT OUTER JOIN
    organizations org ON org.id = (SELECT 
            MAX(id)
        FROM
            organizations)
    where T4.id in(namedParams)" WHERE `dataProviderId`=@rejectApplication;  


set sql_safe_updates=1;